/***********************************************************************/
/*  Copyright (C)           Microcyber Inc. All Rights Reserved        */
/*  File-Name:              MC_YT.inc                                  */
/*                                                                     */
/*  Revision:  1.0                                                     */
/*  Date:      2008-06-10                                              */
/*  Author:    Ning Dekui                                              */
/***********************************************************************/

/*---------------------------------------------------------------------*/
/*    Y t diagram                                                      */
/*---------------------------------------------------------------------*/
MENU OnlineWindow_yt
{
	LABEL  [menu_yt_diagram] ;
	ITEMS
	{
		Page_process_yt
	}
}

MENU Page_process_yt
{
	LABEL [menu_yt_diagram];
	ITEMS
	{
        #ifdef _NCS_PT
            Val_mv_yt,
            Val_temp_yt,
        #endif
        Val_out_yt,
		OCX_out_display_yt,
	}
}

MENU Val_mv_yt
{
	LABEL [trans_value];
	STYLE "OCX_DYNAMIC_YT";
	ITEMS
	{
		trans1_primary_value        (READ_ONLY),
	}
}

MENU Val_temp_yt
{
    LABEL [trans_pres_sensor_temp_value] ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		trans1_temperature_value    (READ_ONLY),
	}
}

MENU Val_out_yt
{
    LABEL [func_out_value] ;
	STYLE		"OCX_DYNAMIC_YT";
	ITEMS
	{
		func1_AI_out_value          (READ_ONLY),
	}
}

MENU OCX_out_display_yt
{
	LABEL  [menu_yt_diagram] ;
	STYLE  "PDMTVPROXY.PDMTVProxyCtrl.1";
	ITEMS
	{
		OCX_ProfilNum_yt,
        OCX_mv_display_yt_1,
        OCX_temp_display_yt_1,
		OCX_out_display_yt_1,
		OCX_UserSettings_yt
	}
}

MENU OCX_mv_display_yt_1
{
	STYLE  "OCX_DYNAMIC_YT";
	ITEMS
	{
		trans1_primary_value            (READ_ONLY),
        trans1_scale_out_lower_value    (READ_ONLY),
        trans1_scale_out_upper_value    (READ_ONLY)
	}
}

MENU OCX_temp_display_yt_1
{
	STYLE  "OCX_DYNAMIC_YT";
	ITEMS
	{
		trans1_temperature_value        (READ_ONLY),
        trans1_min_temperature          (READ_ONLY),
        trans1_max_temperature          (READ_ONLY)
	}
}

MENU OCX_out_display_yt_1
{
	STYLE  "OCX_DYNAMIC_YT";
	ITEMS
	{
		func1_AI_out_value              (READ_ONLY),
		func1_AI_out_lower_range_value  (READ_ONLY),
		func1_AI_out_upper_range_value  (READ_ONLY)
	}
}

VARIABLE OCX_ProfilNum_yt
{
	LABEL  "ProfilID";
	STYLE  "OCX_PROPERTY";
	CLASS  LOCAL;
	TYPE  INTEGER(2)
	{
		DEFAULT_VALUE 0;
	}
	HANDLING    READ;
}

VARIABLE OCX_UserSettings_yt
{
	LABEL  "UserSettings";
	STYLE  "OCX_PROPERTY";
	CLASS  LOCAL;
	TYPE  ASCII (1000)
	{
		DEFAULT_VALUE "";
	}
	HANDLING READ & WRITE;
}
